
-- 1. إنشاء قاعدة جديدة
CREATE DATABASE IF NOT EXISTS conucilofvip_car_rental_system_v2
CHARACTER SET utf8mb4
COLLATE utf8mb4_unicode_ci;

-- 2. استخدام القاعدة
USE conucilofvip_car_rental_system_v2;

-- 3. إنشاء جدول المستخدمين
CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL,
    password VARCHAR(255) NOT NULL,
    email VARCHAR(100),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- 4. إنشاء جدول السيارات
CREATE TABLE cars (
    id INT AUTO_INCREMENT PRIMARY KEY,
    brand VARCHAR(50) NOT NULL,
    model VARCHAR(50) NOT NULL,
    year INT NOT NULL,
    color VARCHAR(30),
    price_per_day DECIMAL(10, 2) NOT NULL,
    status ENUM('available', 'rented', 'maintenance') DEFAULT 'available',
    image_url VARCHAR(255),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- 5. إنشاء جدول الحجوزات
CREATE TABLE bookings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    customer_name VARCHAR(100) NOT NULL,
    customer_email VARCHAR(100) NOT NULL,
    customer_phone VARCHAR(20) NOT NULL,
    car_id INT,
    start_date DATE NOT NULL,
    end_date DATE NOT NULL,
    total_price DECIMAL(10, 2),
    status ENUM('pending', 'confirmed', 'cancelled') DEFAULT 'pending',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (car_id) REFERENCES cars(id)
);

-- 6. إضافة المستخدم (كلمة مرور بدون تشفير)
INSERT INTO users (username, password, email) VALUES 
('admin', 'admin123', 'admin@example.com');

-- 7. إضافة سيارات تجريبية
INSERT INTO cars (brand, model, year, color, price_per_day, status) VALUES 
('تويوتا', 'كامري', 2023, 'أبيض', 150.00, 'available'),
('هوندا', 'أكورد', 2022, 'أسود', 140.00, 'available'),
('بي إم دبليو', 'X5', 2023, 'أزرق', 300.00, 'rented'),
('مرسيدس', 'C-Class', 2023, 'فضي', 280.00, 'available'),
('أودي', 'A6', 2023, 'أحمر', 320.00, 'maintenance'),
('فورد', 'موستنج', 2022, 'أصفر', 250.00, 'available');

-- 8. إضافة حجوزات تجريبية
INSERT INTO bookings (customer_name, customer_email, customer_phone, car_id, start_date, end_date, total_price, status) VALUES
('محمد أحمد', 'mohammed@email.com', '0501234567', 1, '2024-01-15', '2024-01-20', 750.00, 'confirmed'),
('فاطمة علي', 'fatima@email.com', '0509876543', 2, '2024-01-18', '2024-01-25', 980.00, 'pending'),
('خالد محمود', 'khaled@email.com', '0505555555', 3, '2024-01-20', '2024-01-22', 600.00, 'confirmed'),
('سارة محمد', 'sarah@email.com', '0507777777', 4, '2024-01-22', '2024-01-28', 1680.00, 'confirmed');

-- 9. التحقق من البيانات
SELECT * FROM users;
SELECT * FROM cars;
SELECT * FROM bookings;